#include "ItemBitmap.h"

int ItemBitmap::setBitSize(unsigned int bits) 
{
	bitmap.resize(0);
	bitmap.resize(nByte(bits),0);  
	support=0;
	return bitmap.size();
}

ItemBitmap::ItemBitmap(const unsigned int bits)
{
	setBitSize(bits);
}

ItemBitmap::ItemBitmap(const ItemBitmap &i)
{
	/*bitmap.resize( i.bitmap.size() );
	int i,n=bitmap.size();
	for(i=0;i<n;i++) bitmap[i]=i.bitmap[i];*/
	*this=i;
}

ItemBitmap::~ItemBitmap()
{
}

int ItemBitmap::getBit(unsigned int ibit)
{
	int i,j;
	unsigned int t;
	i=ibit / BITS_PER_ELEMENT;
	if(i>=bitmap.size()) return 0;
	j=ibit % BITS_PER_ELEMENT;
	switch( j )
	{
	case 0: t=1; break;
	case 1: t=2; break;
	case 2: t=4; break;
	case 3: t=8; break;
	case 4: t=16; break;
	case 5: t=32; break;
	case 6: t=64; break;
	case 7: t=128; break;
	default: t=0; break;
	}
	return (bitmap[i] & t) !=0;
}

int ItemBitmap::setBit(unsigned int ibit) 
{
	int i,j;
	unsigned int t;
	i=ibit / BITS_PER_ELEMENT;
	if(i>=bitmap.size()) return 0;
	j=ibit % BITS_PER_ELEMENT;
	switch( j )
	{
	case 0: t=1; break;
	case 1: t=2; break;
	case 2: t=4; break;
	case 3: t=8; break;
	case 4: t=16; break;
	case 5: t=32; break;
	case 6: t=64; break;
	case 7: t=128; break;
	default: t=0; break;
	}
	bitmap[i] = bitmap[i] | t;
	//support++;
	return 1;
}

ItemBitmap & ItemBitmap::operator = (const ItemBitmap & rhs)
{
	if(this == &rhs) return *this;
	bitmap.resize( rhs.bitmap.size() );
	int i,n;
	support=rhs.support;
	n=bitmap.size();
	for(i=0;i<n;i++) bitmap[i]=rhs.bitmap[i];
	return *this;
}

int ItemBitmap::intersect(ItemBitmap & rhs)
{
	if(this == &rhs) return 0;
	if(this->bitmap.size() != rhs.bitmap.size()) return 0;
	int i,n;
	n=bitmap.size();
	for(i=0;i<n;i++) 
		bitmap[i]&=rhs.bitmap[i];
	return i;
}

//int ItemBitmap::xnor(ItemBitmap & rhs)
//{
//	if(this == &rhs) return 0;
//	if(this->bitmap.size() != rhs.bitmap.size()) return 0;
//	int i,n;
//	n=bitmap.size();
//	for(i=0;i<n;i++) 
//		bitmap[i]=~(bitmap[i]^rhs.bitmap[i]);
//	return i;
//}

int ItemBitmap::countSupport()
{
	static int n;
	int j;
	int kutil = 0;
	for(int i=0; i<bitmap.size(); i++)
	{
		unsigned int t;
		t=bitmap[i];
		
		for(j=0; j<BITS_PER_ELEMENT; j++, n++)
		{
			if((t&1)==1)
			{
				kutil += keyutil[n];
			}
			t>>=1;
		}
	}
	n = 0;

	support = kutil;
	return support;
}

int ItemBitmap::countActualSupport(vector<int> &ItemProfit, vector<int> &new_closed, vector<int> &remap, vector< vector<int> > &itemcount)
{
	static long int n;	
	int j;
	int util = 0;
	for(int i=0; i<bitmap.size(); i++)
	{
		unsigned int t;
		t=bitmap[i];
				
		for(j=0; j<BITS_PER_ELEMENT; j++,n++)
		{
			if((t&1)==1)
			{
				//kutil += keyutil[n];
				for(int i=0; i<new_closed.size(); i++)
				{
					int iutil = 0, num = 0;
					num += itemcount[i][n];
					iutil= num * ItemProfit[remap[new_closed[i]]];
					//iutil= ItemProfit[remap[new_closed[i]]];
					util += iutil;
				}
			}
			t>>=1;
		}
	}
	n = 0;

	support = util;
	return support;
}

int ItemBitmap::getKeyUtil(vector<int> &keyUtil)
{
	keyutil = keyUtil;
	return 1;
}

int ItemBitmap::isSubsetof(ItemBitmap &rhs)
{
	if(this == &rhs) return 1;
	int i,n;
	unsigned int ta,tb;
	n=bitmap.size();
	if(n!=rhs.bitmap.size()) return 0;
	for(i=0; i<n; i++)
	{
		ta=bitmap[i];
		tb=rhs.bitmap[i];
		/*for(int j=0; j<BITS_PER_ELEMENT; j++)
		{
			if((ta&1)==1 && (tb&1)==0) return 0;
			ta>>=1;
			tb>>=1;
		}*/
		if((ta&tb)==tb) 
		{
			if(i==n-1)
				return 1;
			else
				continue;
		}
		else
			return 0;
	}
	return 0;
}